/*
 
 Copyright (c) 2004 PXI Project Team
 
 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in the
 Software without restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
 Software, and to permit persons to whom the Software is furnished to do so,
 subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in all copies
 or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 
 */

#ifndef ____EXPRESSIONS____
#define ____EXPRESSIONS____

#include <vector>
#include <map>
#include <string>
#include <stack>
#include "quotesrecord.h"
#include "cute_tokenizer.h"
using namespace std;

class variant;

class Token
{
public: // This is really just a glorified struct for now.
	
	Token ( void )
	{
		;	
	}
	
	Token ( const Token & t )
	{
		mString = t.mString;
		mOffset = t.mOffset;
		mType = t.mType;
	}
	
	Token ( const string & s )
	{
		mString = s;
		mOffset = 0;
		mType = 0;
	}
	
	Token ( const string & s, int offs, int ttype )
	{
		mString = s;
		mOffset = offs;
		mType = ttype;
	}

	const Token & operator= ( const Token & t )
	{	
		mString = t.mString;
		mOffset = t.mOffset;
		mType = t.mType;
	}
	
    std::string     mString;        // Actual token string.
    size_t          mOffset;        // Start offset of token in larger string.
    int             mType;          // Type of token.
};

class PXIHyperTalkCompiler
{
public:
	
	struct searchRecord
	{
	
		searchRecord( void )
		{
			code = "";
			cur_ptr = 0;
			found_token = "";
			n_optr = 0;
		}
		searchRecord( const string & c, int p, const string & t )
		{
			code = c;
			cur_ptr = p;
			found_token = t;
			n_optr = 0;
		}

		searchRecord( const string & c, int p, const string & t, int n )
		{
			code = c;
			cur_ptr = p;
			found_token = t;
			n_optr = n;
		}

		string				code;
		int					cur_ptr;
		string				found_token;
		int					n_optr;

	};

PXIHyperTalkCompiler					( void );
PXIHyperTalkCompiler					( const string & );
PXIHyperTalkCompiler					( const PXIHyperTalkCompiler & );

~PXIHyperTalkCompiler					( void );

const	string			compile						( const string & );
const   string &		xcompile					( int, int );
const	string &		get_source					( void );
searchRecord			compile_container			( const string &, int );
searchRecord			push_factor					( int, string );
searchRecord			push_expr					( int, string, const vector < string > & );

void					echo						( void );
void					echo_tokens					( void );

void					initialize					( void );

const   vector < Token > &	
						tokenize					( const string & );
void					endToken					( Token & );

private:

void					write_symbols				( void );

bool					is_a_padding_symb			( const char );
short					compare_precedence			( const string&, const string& );
bool					get_associativity			( const string& );
bool					is_a_number					( const string& );
bool					is_an_operator				( const string& );
bool					is_not_a_factor				( const string& );
bool					is_a_chunk_word				( const string& );
bool					is_tens_place_ordinal		( const string& );
bool					is_ones_place_ordinal		( const string& );
int						is_a_shortfunc				( const string& );
int						shortfunc					( const string& );

int						strcmpi						( const char*, const char* );
int						stricmp						( const char*, const char* );

string					ltrim						( const string& );
string					rtrim						( const string& );
string					trim						( const string& );

const   string			makeSimpleValue				( const string&, const string& );
const   string			makeSimpleConstantValue		( const string&, const string& );
const	string			makeSimpleContainerValue	( const string&, const string& );
const   string			makeInlineOperator			( const string& );

bool					haveCurrentGlobal			( const string& );
int						getCurrentGlobalIndex		( const string& );

string					source;
string					composite_asmcode;

vector < Token >		symbols;
vector < pair < string, int > >		intern_symb_short;
vector < pair < string, int > >		intern_symb_extended;
vector < string >		incrementor_symbs;
vector < string >		decrementor_symbs;
vector < string >		continuable_symbs;
map < string, int >		current_globals;

stack  < variant >		control_stack;
stack  < variant >      master_control_stack;
stack  < int >			control_type_stack;
stack  < variant >		loop_stack;
int						fendif_counter;
bool					last_line_was_jump;
bool					no_if_processing;
bool					no_bracket_processing;

map < string, int >		precedence;

int						op_ptr;
};

#endif
